/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/********************************************************************/
/* File seq_pars.h                                                  */
/********************************************************************/

#ifndef _SEQ_PARS_H_INCLUDED
#define _SEQ_PARS_H_INCLUDED

#include <xtypedef.h>
#include "xseqbool.h"

#define YYSEQBUFSIZE 4096  /* buffer size for a complete sequence */
                              /* description                         */

/* stack size of yacc parser. Dont worry, if this value is too small,   */
/* yacc issues an error.                                                */
#define YYMAXDEPTH  32


typedef struct { char * tok_name;
                 int vectorlen;
                 int position;
               } token;

typedef struct { char  * name;
                 int   states;         /* number of sequencer states  */
                 int   inputs;         /* number of sequencer inputs  */
                 int   outputs;        /* number of sequencer outputs */
                 int   input_tokens;   /* number of sequencer input names  */
                 int   output_tokens;  /* number of sequencer output names */
                 const token * input_tokenlist;
                 const token * output_tokenlist;
                 const token * state_tokenlist;
                 char  * ram_array_ptr; /*this array holds the sequencer map */
                 boolmap ** default_xcond;
                 boolmap ** accumul_xcond;
               } sequencer_descriptor; 

typedef struct { int entries;
                 const sequencer_descriptor * list[16];
               } sequencer_descriptor_list;


/* parameters which can be queried with get_sequencer_param() */

#define NO_OF_STATES  201
#define NO_OF_INPUTS  202
#define NO_OF_OUTPUTS  203
#define SEQ_RAM_WIDTH  204
#define SEQ_RAM_DEPTH  205

/* function prototypes */


void error_msg(char *);

/* parses the standard sequencer description */
bx_errtype ParseSequenceDescription();

bx_errtype InitSequencerDescriptor(char *, sequencer_descriptor *);

void FreeSequencerDescriptor();

bx_errtype GetSequencerParam(bx_int32, bx_int32ptr);

bx_errtype ReadSequencerRamline(bx_int32, bx_int32ptr,bx_int32ptr);

#endif
